﻿//===============================================================================
// Microsoft patterns & practices Enterprise Library
// Core
//===============================================================================
// Copyright © Microsoft Corporation.  All rights reserved.
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY
// OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT
// LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE.
//===============================================================================

namespace Microsoft.Practices.EnterpriseLibrary.Security.Configuration.Design
{
    /// <summary> 
    /// Specifies the underline styles for a segment of rich text. 
    /// </summary> 
    enum UnderlineStyle
    {
        /// <summary> 
        /// No underlining. 
        /// </summary> 
        None = 0,

        /// <summary> 
        /// Single-line solid underline. 
        /// </summary> 
        Normal = 1,

        /// <summary> 
        /// Single-line underline broken between words. 
        /// </summary> 
        Word = 2,

        /// <summary> 
        /// Double-line underline. 
        /// </summary> 
        Double = 3,

        /// <summary> 
        /// 'Dotted' pattern underline. 
        /// </summary> 
        Dotted = 4,

        /// <summary> 
        /// 'Dash' pattern underline. 
        /// </summary> 
        Dash = 5,

        /// <summary> 
        /// 'Dash-dot' pattern underline. 
        /// </summary> 
        DashDot = 6,

        /// <summary> 
        /// 'Dash-dot-dot' pattern underline. 
        /// </summary> 
        DashDotDot = 7,

        /// <summary> 
        /// Single-line wave style underline. 
        /// </summary> 
        Wave = 8,

        /// <summary> 
        /// Single-line solid underline with extra thickness. 
        /// </summary> 
        Thick = 9,

        /// <summary> 
        /// Single-line solid underline with less thickness. 
        /// </summary> 
        Hairline = 10,

        /// <summary> 
        /// Double-line wave style underline. 
        /// </summary> 
        DoubleWave = 11,

        /// <summary> 
        /// Single-line wave style underline with extra thickness. 
        /// </summary> 
        HeavyWave = 12,

        /// <summary> 
        /// 'Long Dash' pattern underline. 
        /// </summary> 
        LongDash = 13,

        /// <summary> 
        /// 'Dash' pattern underline with extra thickness. 
        /// </summary> 
        ThickDash = 14,

        /// <summary> 
        /// 'Dash-dot' pattern underline with extra thickness. 
        /// </summary> 
        ThickDashDot = 15,

        /// <summary> 
        /// 'Dash-dot-dot' pattern underline with extra thickness. 
        /// </summary> 
        ThickDashDotDot = 16,

        /// <summary> 
        /// 'Dotted' pattern underline with extra thickness. 
        /// </summary> 
        ThickDotted = 17,

        /// <summary> 
        /// 'Long Dash' pattern underline with extra thickness. 
        /// </summary> 
        ThickLongDash = 18
    }

}
